<?php
/**
 * This file stores all default settings.
 *
 * @category Framework
 * @package  OxyProps
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @license  https://www.gnu.org/licenses/gpl-2.0.html  GPL v2 or later
 * @link     https://oxyprops.com                       OxyProps Website
 * @since    1.5.0
 */

namespace OxyProps\Inc;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles custom normalize
 *
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @since    1.5.0
 */
final class Normalize {

	/**
	 * Unique instance of Normalize
	 *
	 * @author   Cédric Bontems <cedric@thewebforge.dev>
	 * @since    1.5.0
	 *
	 * @var object Self stored instance
	 */
	private static $instance = null;

	/**
	 * Returns the unique instance of Normalize
	 * and creates one if it does not already exist.
	 *
	 * @author   Cédric Bontems <cedric@thewebforge.dev>
	 * @since    1.5.0
	 *
	 * @return object Defaults singleton.
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new Normalize();
		}
		return self::$instance;
	}

	/**
	 * Get the custom normalize content
	 *
	 * @param string  $builder  The active site builder.
	 * @param boolean $where    Should the :where statement be used for selectors.
	 * @return string
	 */
	public function get_normalize( string $builder = 'Oxygen', bool $where = true ) {
		$normalize_css = '';
		$this->get_html_normalize( $normalize_css, $builder, $where );
		return $normalize_css;
	}

	/**
	 * Adds Html normalize
	 *
	 * @param string  $normalize_css    The cumulative custom normalize CSS.
	 * @param string  $builder          The active site builder.
	 * @param boolean $where            Should the :where statement be used for selectors.
	 * @return void
	 */
	public function get_html_normalize( string &$normalize_css, string $builder = 'Oxygen', bool $where = true ) {
		$normalize_css .= $where ? ':where(html){' : 'html{';
		$normalize_css .= '}';
	}
}
